<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<span class="header">Publications</span>
	</div>
</div>
<style>
.center {
  margin: 20px auto;
}
.center a.default:link {
  color: #1a285f;
  text-decoration: none;
  font-weight: normal;
}
.center a::before {
  font-family: "Font Awesome 5 Free";
  content: "\f078 ";
  font-weight: 700;
  font-style: normal;
  font-size: 12px;
  vertical-align: 1px;
  margin-left: 2px;
}
.center p {
  font-size: 16px;
  text-align: left;
  margin: 6px 0;
}
</style>
<div class="center centraliza">
	<p>&nbsp;</p>
    <p><a href="#EstadoDemocracia" class="default"> The State of Democracy in Latin American series</a></p>
    <p><a href="#JournalDemocracy" class="default"> Journal of Democracy in Portuguese</a></p>
    <p><a href="#Futuribles" class="default"> Futuribles in Portuguese</a></p>
    <p><a href="#EnsaiosDemocracia" class="default"> Digital Democracy Essays series</a></p>
    <p><a href="#CambiosGeopoliticos" class="default"> Global Geopolitical Changes and the Future of Democracy in Latin America series</a></p>
    <p><a href="#MediosComunicacion" class="default"> Media and Democracy series</a></p>
    <p><a href="#DocumentosTrabajo" class="default"> Working Papers Plataforma Democrática series</a></p>
    <p><a href="#CohesionSocial" class="default"> Social Cohesion and Democracy series</a></p>    
    <p><a href="#RecursosPesquisa" class="default"> Research Sources on the Internet series</a></p>
    <p><a href="#InformesPlataforma" class="default"> Reports Plataforma Democrática series</a></p>   
    <p><a href="#ConexaoAmericaLatina" class="default"> Latin America Connection Collection</a></p>  
  </div>

<section id="primary">
	<div id="content" role="main">
		<div>
			<div id="EstadoDemocracia" class="point"></div>
			<?php get_template_part( 'loop-colecao-o-estado-da-democracia-na-america-latina' ); ?>

			<div id="JournalDemocracy" class="point"></div>
			<?php get_template_part( 'loop-journal-of-democracy-em-portugues'); ?>
			
			<div id="Futuribles" class="point"></div>
			<?php get_template_part( 'loop-futuribles-em-portugues'); ?>

			<div id="EnsaiosDemocracia" class="point"></div>
			<?php get_template_part( 'loop-colecao-ensaios-democracia-digital'); ?>

			<div id="CambiosGeopoliticos" class="point"></div>
			<?php get_template_part( 'loop-colecao-mudancas-geopoliticas-globais-e-o-futuro-da-democracia-na-america-latina'); ?>
			
			<div id="MediosComunicacion" class="point"></div>
			<?php get_template_part( 'loop-colecao-meios-de-comunicacao-e-democracia'); ?>
			
			<div id="DocumentosTrabajo" class="point"></div>
			<?php get_template_part( 'loop-colecao-documentos-de-trabalho-plataforma-democratica'); ?>
			
			<div id="CohesionSocial" class="point"></div>
			<?php get_template_part( 'loop-colecao-coesao-social-e-democracia'); ?>
			
			<div id="RecursosPesquisa" class="point"></div>
			<?php get_template_part( 'loop-colecao-fontes-de-pesquisa-na-internet'); ?>
			
			<div id="InformesPlataforma" class="point"></div>
			<?php get_template_part( 'loop-colecao-informes-plataforma-democratica'); ?>
			
			<div id="ConexaoAmericaLatina" class="point"></div>
			<?php get_template_part( 'loop-colecao-conexao-america-latina'); ?>
				




		</div>
	</div><!-- #content -->
</section><!-- #primary -->


<?php get_sidebar(); ?>
<?php get_footer(); ?>
