<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<span class="header">Video Library</span>
	</div>
</div>
<section id="primary">
	<div id="content" role="main">
		<div class="centraliza">
			<p>We put at your disposal the videos with all the presentations of the seminars and conferences held by the Democratic Platform.</p>
		<?php
// CONTAGEM DOS TÍTULOS
$posts = query_posts('post_type=video_library&showposts=-1'); 
$count = count($posts);
echo '<b>' .$count. '</b> videos<br>';
?>

			<?php query_posts('post_type=video_library&order=DESC'); ?>
			<div class='centraliza'>
			<?php if (have_posts()) : ?>
			<?php while (have_posts()) : the_post(); ?>
			
				<div class="wrap-video">
				<?php 
				if ( has_post_thumbnail() ) {
					echo '<div class="thumbVid">';
					the_post_thumbnail('full');
					echo '</div>';
					echo '<div class="info-videoteca-metade">';
				}
				else {
					echo '<div class="info-videoteca">';
				}
				?>
				
				<?php the_subtitle('<h2>','</h2>'); ?>
				<?php the_title('<h3>','</h3>')?>
				<p>
					<a href="<?php the_permalink(); ?>" target="_self" alt="Acesse a Videoteca <?php get_the_title(); ?>" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> See more</a><br><br>
				</p>
				
				
				</div>
			</div>
			<?php endwhile; ?>
			<?php else : ?>
			<?php endif; ?>
		<div>
		
		
		</div>
	</div><!-- #content -->
</section><!-- #primary -->

	</div><!-- #content -->
</section><!-- #primary -->


<style>


</style>	

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
