<?php
/**
 * Template for displaying Search Results pages
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>

		<section id="primary">
			<div id="content" role="main">

			<?php if ( have_posts() ) : ?>

				<div class="barra-titulo">
					<div class="centraliza">
						<span class="header"><?php printf( __( 'Search Results for: %s', 'twentyeleven' ), '<span>' . get_search_query() . '</span>' ); ?></span>
					</div>
				</div>

				<?php twentyeleven_content_nav( 'nav-above' ); ?>

				<?php /* Start the Loop */ ?>
				<div class="centraliza">
				<div class="wrap_pesquisa">
				<?php
				while ( have_posts() ) :
					the_post();
					?>

					<?php
						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to overload this in a child theme then include a file
						 * called content-___.php (where ___ is the Post Format name) and that
						 * will be used instead.
						 */
						//get_template_part( 'content', get_post_format() );
						echo '<div class="bloc_pesquisa">';
						echo '<h2>' . get_the_title() . '</h2>';
						
						echo '<a href="' . get_the_permalink() . ' "target="_self" alt="" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> Leia mais</a><br><br>';
      
						
						echo '</div>';
						
					?>

				<?php endwhile; ?>
				</div>
				</div>
				<?php twentyeleven_content_nav( 'nav-below' ); ?>

			<?php else : ?>

				<article id="post-0" class="post no-results not-found">
					<header class="entry-header">
						<h1 class="entry-title centraliza"><?php _e( 'Nothing Found', 'twentyeleven' ); ?></h1>
					</header><!-- .entry-header -->

					<div class="entry-content centraliza">
						<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'twentyeleven' ); ?></p>
						<?php get_search_form(); ?>
					</div><!-- .entry-content -->
				</article><!-- #post-0 -->

			<?php endif; ?>

			</div><!-- #content -->
		</section><!-- #primary -->

<style>
.bloc_pesquisa h2 {
  font-size: 24px;
  font-weight: 400;
  margin: 10px 0;
  line-height: 100%;
  color: #b5653c;
}
.bloc_pesquisa {
  
  border-top: 1px solid;
  margin-top: 10px;
  padding: 30px 0;
  width: 100%;
}
</style>

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
