<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<h1><span class="header">Virtual Libraries</span></h1>
	</div>
</div>
<section id="primary">
	<div id="content" role="main">
		<div class="centraliza">
      <div class="wrap-biblioteca">
        <h2 class="lista-interna"><?php the_field('autor'); ?>. <i><?php the_title(); ?></i></h2>
      <?php
        // Must be inside a loop.
        
        if ( has_post_thumbnail() ) {
          echo '<div class="thumb-biblioteca">' . get_the_post_thumbnail() . '</div>';
          echo '<div class="content-biblioteca"><p>' . get_the_content() . '</p></div>';
        }
        else {
          the_content();
        }
      ?>
      </div>

<div class="lista-itens">
    <?php if( get_field( 'arquivo' ) ): ?>
		<p><b>File:</b> <a href="<?php the_field('arquivo'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Download file</a><br></p>
   
      <?php endif; ?>
     <?php if( get_field( 'url_original' ) ): ?>
      <p><b>Original URL:</b> <a href="<?php the_field('url_original'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> See file</a><br></p>
      
    <?php endif; ?>
    <?php if( get_field( 'cached_file' ) ): ?>
    <p><b>Cached file:</b> <a href="<?php the_field('cached_file'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> See more</a></p>
    
    <?php endif; ?>
    <?php if( get_field( 'link' ) ): ?>
    <p><b>Link:</b> <a href="<?php the_field('link'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> See file</a></p>
   
    <?php endif; ?>
</div>	
  
  
  </div>
	</div><!-- #content -->
</section><!-- #primary -->
<div class="centraliza btn-bottom" style="text-align:center">
<p>
  <a onclick="javascript:history.back()" target="_self" alt="Voltar" class="btn-mais btn-menor"><i class="fa fa-angle-left" aria-hidden="true"></i> back</a>
  <a href="<?php echo get_site_url(); ?>/bibliotecas-virtuais" target="_self" alt="Pesquisa" class="btn-mais btn-menor"><i class="fa fa-angle-right" aria-hidden="true"></i> New Search</a>
</p>
</div>

	</div><!-- #content -->
</section><!-- #primary -->

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
