<?php

/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header();

global $wp_query;

$title = isset($_POST['title']) ? $_POST['title'] : $_GET['title'];
$author = isset($_POST['author']) ? $_POST['author'] : $_GET['author'];
$lang = isset($_POST['lang']) ? $_POST['lang'] : $_GET['lang'];
?>
<?php if (is_string($title) || is_string($author) || is_string($lang)) : ?>
  <div class="barra-titulo">
    <div class="centraliza">
      <?php
      //Guarda o id do blod atual
      $original_blog_id = get_current_blog_id(); 

      // Altera para o blod em português
      switch_to_blog(1);

      // CONTAGEM DOS TÍTULOS
      // query_posts('biblioteca&cat_biblioteca=sociedade-da-informacao&showposts=-1'); 
      $posts = $wp_query->query(
        array(
          'post_type' => 'biblioteca',
          'cat_biblioteca' => 'sociedade-da-informacao',
          'showposts' => -1,
          's' => is_string($title) ? $title : '',
          'meta_query' => array(
            array(
              'key' => 'autor',
              'value' => is_string($author) ? $author : '',
              'compare_key' => '=',
              'compare' => 'LIKE'
            ),
            array(
              'key' => 'idioma',
              'value' => is_string($lang) ? $lang : '',
              'compare_key' => '=',
              'compare' => 'LIKE'
            )
          )
        )
      );
      $count = count($posts);
      ?>
      <span class="header">Bibliotecas Virtuales <i class="fa fa-angle-right menor" aria-hidden="true"></i> <?php the_title(); ?> <?php echo "(" . $count . ")"; ?></span>
    </div>
  </div>
  <section id="primary">
    <div id="content" role="main">
      <div>
        <div class="centraliza">
          <?php echo "<b>" . $count . "</b> títulos Sociedad de la Informacion<br><br>"; ?>
        </div>
        <div class='barra-titulo'>
          <div class='centraliza'>
            <h2>Sociedad de la Informacion</h2>
          </div>
        </div>
        <?php
        // query_posts('post_type=biblioteca&cat_biblioteca=sociedade-da-informacao&showposts=3&order=DESC');
        $wp_query->query(
          array(
            'post_type' => 'biblioteca',
            'cat_biblioteca' => 'sociedade-da-informacao',
            'showposts' => 6,
            'order' => 'DESC',
            'paged' => $paged,
            's' => is_string($title) ? $title : '',
            'meta_query' => array(
              array(
                'key' => 'autor',
                'value' => is_string($author) ? $author : '',
                'compare_key' => '=',
                'compare' => 'LIKE'
              ),
              array(
                'key' => 'idioma',
                'value' => is_string($lang) ? $lang : '',
                'compare_key' => '=',
                'compare' => 'LIKE'
              )
            )
          )
        );
        ?>
        <?php if (have_posts()) : ?>
          <?php while (have_posts()) : the_post(); ?>
            <div class='centraliza'>
              <?php
              if (has_post_thumbnail()) {
                echo '<div class="bloc_publicacao"><div class="mask-img">' . get_the_post_thumbnail() . '</div>';
              }
              ?>
              <div class="info-publicacao">
                <h2><?php the_title(); ?> </h2>
                <h3><i><b><?php the_field('autor'); ?></b></i></h3>
                <!--<a href="<?php //the_permalink(); ?>" target="_self" alt="Acesse a Publicação <?php //get_the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Acesse aqui</a><br><br>-->
                <div class="conjuntoBtn">
                  <?php if( get_field( 'arquivo' ) ): ?>
                    <a href="<?php the_field('arquivo'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Descargar archivo</a>
                  <?php endif; ?>
                  <?php if( get_field( 'url_original' ) ): ?>
                    <a href="<?php the_field('url_original'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Ver Archivo</a>
                  <?php endif; ?>
                  <?php if( get_field( 'cached_file' ) ): ?>
                    <a href="<?php the_field('cached_file'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Ver Más</a>
                  <?php endif; ?>
                  <?php if( get_field( 'link' ) ): ?>
                    <a href="<?php the_field('link'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Acceder al archivo</a>
                  <?php endif; ?>
                </div>
              <style>
                .conjuntoBtn a {
                  margin-right: 20px !important;
                }
                .conjuntoBtn {
                  display: flex !important;
                }
              </style>
              </div><br>
              <hr>
            </div>
          <?php endwhile; ?>
          <div class="centraliza btn-paginacao"><?php ww_pagination($title, $author, $lang); ?></div>
          <?php wp_reset_postdata(); ?>
        <?php else : ?>
          <div class="centraliza">
            <h2 style="font-size: 18px;margin-top: 30px;">No hay títulos para Sociedad de la Informacion</h2>
            <a href="<?php echo get_site_url(); ?>/sociedade-da-informacao" target="_self" alt="Busca" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Nueva búsqueda</a><br><br>
              
          </div>
        <?php 
        endif; 
        
        // Volta para o blog atual 
        switch_to_blog( $original_blog_id ); 
        ?>
      </div>
    </div><!-- #content -->
  </section><!-- #primary -->
<?php else : ?>
  <div class="barra-titulo">
    <div class="centraliza">
      <span class="header">Bibliotecas Virtuales <i class="fa fa-angle-right menor" aria-hidden="true"></i> <?php the_title(); ?></span>
    </div>
  </div>
  <section id="primary">
    <div id="content" role="main">
      <div class="centraliza">
      <p>La Biblioteca cuenta con una colección de documentos especializados en temas de la Democracia en América Latina. En esta sección puedes tener acceso gratuito a nuestra colección de 20.000 títulos. Los títulos se pueden buscar por autor o por palabras clave en el título de la obra.</p>
         <p>Esta biblioteca se actualizó hasta 2015.</p>
         <p>Ingrese los criterios de búsqueda a continuación (elija 1 o más opciones o vaya directamente a Buscar)</p>
         <form id="formSocietyOfInformationSearch" method="POST" action="<?php get_permalink() ?>">
           Palabra sin título:<br>
           <input type="text" name="title" style="width: 900px;" /><br>
           Autor:<br>
           <input type="text" name="autor" style="width: 900px;" /><br>
           Idioma:<br>
          <input type="radio" name="lang" value="Alemão" />Alemão
          <input type="radio" name="lang" value="Espanhol" />Español
          <input type="radio" name="lang" value="Francês" />Francés
          <input type="radio" name="lang" value="Inglês" />Inglés
          <input type="radio" name="lang" value="Italiano" />Italiano
          <input type="radio" name="lang" value="Português" />Português
          <br>
          <input type="button" id="societyOfInformationSearch" value="Buscar">
        </form>
      </div>
    </div>
  </section>
<?php endif; ?>
<?php //get_sidebar(); 
?>
<?php get_footer(); ?>