<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<h1><span class="header">Publicaciones</span></h1>
	</div>
</div>
<section id="primary">
	<div id="content" role="main">
		<div class="centraliza">
      <div class="wrap-biblioteca publicacoes">
        <h2 class="lista-interna"><i><?php the_title(); ?></i></h2>
        <?php if( get_field( 'autor' ) ): ?>
          <h3 class="lista-interna"><i><?php the_field('autor'); ?></i></h3>
        <?php endif; ?>
        
      <?php
        // Must be inside a loop.
        
        if ( has_post_thumbnail() ) {
          echo '<div class="thumb-biblioteca publicacoes">' . get_the_post_thumbnail() . '</div>';
          echo '<div class="content-biblioteca publicacoes"><div class="capitulos">' . get_field('capitulos') . '</div></div>';
        }
        else {
          the_field('capitulos');
        }
      ?>
      </div>

<div class="lista-itens">
    <?php if( get_field( 'link_ler_texto' ) ): ?>
		<p><a href="<?php the_field('link_ler_texto'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Download</a></p>
   
      <?php endif; ?>
     <?php if( get_field( 'link_compre' ) ): ?>
      <p><a href="<?php the_field('link_compre'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Acceder al archivo</a></p>
      
    <?php endif; ?>
    <?php if( get_field( 'sumario' ) ): ?>
    <p><a href="<?php the_field('sumario'); ?>" target="_blank" alt="<?php the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Acceder más</a></p>
    
    <?php endif; ?>
  </div>	
  
  
  </div>
	</div><!-- #content -->
</section><!-- #primary -->
<div class="centraliza btn-bottom" style="text-align:center">
<p>
  <a onclick="javascript:history.back()" target="_self" alt="Voltar" class="btn-mais btn-menor"><i class="fa fa-angle-left" aria-hidden="true"></i> voltar</a>
  <a href="<?php echo get_site_url(); ?>/bibliotecas-virtuais" target="_self" alt="Pesquisa" class="btn-mais btn-menor"><i class="fa fa-angle-right" aria-hidden="true"></i> Nueva busqueda</a>
</p>
</div>

	</div><!-- #content -->
</section><!-- #primary -->


<style>
.wrap-biblioteca.publicacoes {
  width: 100%;
  display: table;
}
.thumb-biblioteca.publicacoes {
  float: left;
  padding: 20px;
}
.content-biblioteca.publicacoes {
  float: left;
}

.capitulos a::before {
  font-family: "Font Awesome 5 Free";
  content: "\f078";
  font-weight: 700;
  font-style: normal;
  font-size: 12px;
  vertical-align: 1px;
  margin-right: 6px;
}
.capitulos a {
  background-position: 10px -48px;
  border-color: #b5653c;
  color: #b5653c;
  margin: 12px 0;
  clear: both;
  border: 1px solid;
  padding: 8px 16px;
  text-transform: uppercase;
  font-family: 'Dosis', sans-serif;
  font-size: 12px;
}

</style>



<?php //get_sidebar(); ?>
<?php get_footer(); ?>
