<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<span class="header">Publicações</span>
	</div>
</div>
<section id="primary">
	<div id="content" role="main">
		<div>
		<?php 
		
		$terms = get_terms([
			'taxonomy' => 'cat_publicacoes',
      'orderby' => 'description',
			'hide_empty' => true,
			
		]);
		foreach ($terms as $term){
			//echo $term->slug." : ";
			//echo $term->name." : ";
      
			echo "<div class='barra-titulo'><div class='centraliza'><h1>" . $term->name . "</h1></div></div>";
			echo "<div class='centraliza'>";
			query_posts('post_type=publicacoes&cat_publicacoes='. $term->slug .'&order=DESC');
			if (have_posts()) : while (have_posts()) : the_post();
			echo "<div class='bloc_publicacao'><div class='mask-img'>";
      the_post_thumbnail('thumb-capa');
      echo "</div>";
      echo "<div class='info-publicacao'>
      <h2>";
			the_title();
			echo "</h2>";
      echo "<h3>";
			the_field('autor');
			echo "</h3>";
  
      if( get_field( 'link_ler_texto' ) ): 
      echo '<a href="' .get_field('link_ler_texto'). ' "target="_blank" alt="Leia a Publicação ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> LEIA AQUI O TEXTO COMPLETO GRÁTIS </a><br><br>';
      else : 
      endif; 

      if( get_field( 'link_compre' ) ): 
      echo '<a href="' .get_field('link_compre'). ' "target="_blank" alt="COMPRE AQUI A VERSÃO IMPRESSA DA PUBLICAÇÃO ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> COMPRE AQUI A VERSÃO IMPRESSA </a><br><br>';
      else : 
      endif;

      if( get_field( 'sumario' ) ): 
        echo '<a href="' .get_field('sumario'). ' "target="_blank" alt="SUMÁRIO DA PUBLICAÇÃO ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> SUMÁRIO</a><br><br>';
        else : 
        endif;
      
	
      echo "</div>";
      echo "</div>";
			endwhile; 
			else : echo "-";
			endif;
			wp_reset_query();

      echo "</div>";
		  }
		
		?>
		
		</div>
	</div><!-- #content -->
</section><!-- #primary -->

	</div><!-- #content -->
</section><!-- #primary -->


<style>
/* lista */
.info-publicacao {
  width: 100%;
}
.info-publicacao h2 {
  font-size: 24px;
  font-weight: 400;
  margin: 10px 0;
  line-height: 100%;
  color: #b5653c;
}
.info-publicacao h3 {
  font-size: 17px;
  margin-bottom: 8px;
}
.info-publicacao .btn-mais {
  background: url(../images/bt-arrow.png) 10px 13px no-repeat;
    background-position-x: 10px;
    background-position-y: 13px;
  padding: 10px 20px 10px 20px;
  border: 1px solid #fff;
    border-top-color: rgb(255, 255, 255);
    border-right-color: rgb(255, 255, 255);
    border-bottom-color: rgb(255, 255, 255);
    border-left-color: rgb(255, 255, 255);
  font-size: 14px;
  color: #fff;
  font-family: 'Dosis', sans-serif;
  float: left;
  text-transform: uppercase;
}
.info-publicacao .btn-mais {
  background-position: 10px -48px;
  border-color: #b5653c;
  color: #b5653c;
  margin: 12px 0;
  clear: both;
}

.bloc_publicacao {
  display: flex;
  border-top: 1px solid;
  margin-top: 10px;
  padding: 30px 0;
  width: 100%;
}
.bloc_publicacao .mask-img {
  width: 300px;
  overflow: hidden;
  float: left;
}
.bloc_publicacao .mask-img img {
  width: auto;
  display: block;
  margin: 0 auto;
  max-height: 100%;
  height: auto;
}

.barra-titulo-m span.header {
  font-size: 33px;
  padding: 40px 0 10px;
  font-weight: 400;
  display: block;
  color: #1a285f !important;
  border-bottom: 1px solid #1a285f;
}
#primary {
  padding-top: 30px;
  padding-bottom: 30px;
}
.barra-titulo {
  width: 100%;
  margin: 0 auto;
  background: #1a285f;
  height: 70px;
  display: table;
}
.barra-titulo span.header {
  font-size: 33px;
  font-weight: 400;
  display: block;
  color: #ffffff;
  line-height: 70px;
}

.barra-titulo h1 {
  font-size: 28px;
  font-weight: 400;
  color: #ffffff;
  line-height: 70px;
}

</style>	

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
