<?php

/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header();

global $wp_query;

$title = isset($_POST['title']) ? $_POST['title'] : $_GET['title'];
$author = isset($_POST['author']) ? $_POST['author'] : $_GET['author'];
$lang = isset($_POST['lang']) ? $_POST['lang'] : $_GET['lang'];
?>
<?php if (is_string($title) || is_string($author) || is_string($lang)) : ?>
  <div class="barra-titulo">
    <div class="centraliza">
      <?php
      // CONTAGEM DOS TÍTULOS
      // query_posts('biblioteca&cat_biblioteca=sociedade-da-informacao&showposts=-1'); 
      $posts = $wp_query->query(
        array(
          'post_type' => 'biblioteca',
          'cat_biblioteca' => 'sociedade-da-informacao',
          'showposts' => -1,
          's' => is_string($title) ? $title : '',
          'meta_query' => array(
            array(
              'key' => 'autor',
              'value' => is_string($author) ? $author : '',
              'compare_key' => '=',
              'compare' => 'LIKE'
            ),
            array(
              'key' => 'idioma',
              'value' => is_string($lang) ? $lang : '',
              'compare_key' => '=',
              'compare' => 'LIKE'
            )
          )
        )
      );
      $count = count($posts);
      ?>
      <span class="header">Bibliotecas Virtuais <i class="fa fa-angle-right menor" aria-hidden="true"></i> <?php the_title(); ?> <?php echo "(" . $count . ")"; ?></span>
    </div>
  </div>
  <section id="primary">
    <div id="content" role="main">
      <div>
        <div class="centraliza">
          <?php echo "<b>" . $count . "</b> títulos SOCIEDADE DA INFORMAÇÃO<br><br>"; ?>
        </div>
        <div class='barra-titulo'>
          <div class='centraliza'>
            <h2>Sociedade da Informação</h2>
          </div>
        </div>
        <?php
        // query_posts('post_type=biblioteca&cat_biblioteca=sociedade-da-informacao&showposts=3&order=DESC');
        $wp_query->query(
          array(
            'post_type' => 'biblioteca',
            'cat_biblioteca' => 'sociedade-da-informacao',
            'showposts' => 6,
            'order' => 'DESC',
            'paged' => $paged,
            's' => is_string($title) ? $title : '',
            'meta_query' => array(
              array(
                'key' => 'autor',
                'value' => is_string($author) ? $author : '',
                'compare_key' => '=',
                'compare' => 'LIKE'
              ),
              array(
                'key' => 'idioma',
                'value' => is_string($lang) ? $lang : '',
                'compare_key' => '=',
                'compare' => 'LIKE'
              )
            )
          )
        );
        ?>
        <?php if (have_posts()) : ?>
          <?php while (have_posts()) : the_post(); ?>
            <div class='centraliza'>
              <?php
              if (has_post_thumbnail()) {
                echo '<div class="bloc_publicacao"><div class="mask-img">' . get_the_post_thumbnail() . '</div>';
              }
              ?>
              <div class="info-publicacao">
                <h2><?php the_title(); ?> </h2>
                <h3><i><b><?php the_field('autor'); ?></b></i></h3>
                <a href="<?php the_permalink(); ?>" target="_self" alt="Acesse a Publicação <?php get_the_title(); ?>" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Acesse aqui</a><br><br>
              </div><br>
              <hr>
            </div>
          <?php endwhile; ?>
          <div class="centraliza btn-paginacao"><?php ww_pagination($title, $author, $lang); ?></div>
          <?php wp_reset_postdata(); ?>
        <?php else : ?>
          <div class="centraliza">
            <h2 style="font-size: 18px;margin-top: 30px;">Não existem títulos para Sociedade da Informação</h2>
            <a href="<?php echo get_site_url(); ?>/sociedade-da-informacao" target="_self" alt="Busca" class="btn-mais"><i class="fa fa-angle-right" aria-hidden="true"></i> Fazer nova busca</a><br><br>
              
          </div>
        <?php endif; ?>
      </div>
    </div><!-- #content -->
  </section><!-- #primary -->
<?php else : ?>
  <div class="barra-titulo">
    <div class="centraliza">
      <span class="header">Bibliotecas Virtuais <i class="fa fa-angle-right menor" aria-hidden="true"></i> <?php the_title(); ?></span>
    </div>
  </div>
  <section id="primary">
    <div id="content" role="main">
      <div class="centraliza">
        <p>A Biblioteca dispõe de um fundo documental especializado nos temas da Democracia na América Latina. Nesta seção você poderá ter livre acesso a nossa coleção de 20.000 títulos. Os títulos podem ser buscados por autor ou por palavras-chave no título do trabalho.</p>
        <p>Esta biblioteca foi atualizada até 2015.</p>
        <p>Informe abaixo os critérios da pesquisa (escolha 1 ou mais opções ou vá direto a Buscar)</p>
        <form id="formSocietyOfInformationSearch" method="POST" action="<?php get_permalink() ?>">
          Palavra no título:<br>
          <input type="text" name="title" style="width: 900px;" /><br>
          Autor:<br>
          <input type="text" name="author" style="width: 900px;" /><br>
          Idioma:<br>
          <input type="radio" name="lang" value="Alemão" />Alemão
          <input type="radio" name="lang" value="Espanhol" />Español
          <input type="radio" name="lang" value="Francês" />Francês
          <input type="radio" name="lang" value="Inglês" />Inglês
          <input type="radio" name="lang" value="Italiano" />Italiano
          <input type="radio" name="lang" value="Português" />Português
          <br>
          <input type="button" id="societyOfInformationSearch" value="Buscar">
        </form>
      </div>
    </div>
  </section>
<?php endif; ?>
<?php //get_sidebar(); 
?>
<?php get_footer(); ?>