<?php

/**
 * Template name: Fura Bolha
 */

get_header(); ?>

<div class="barra-titulo">
  <div class="centraliza">
    <span class="header">
      <?php the_title(); ?>
    </span>
  </div>
</div>

<div id="main" class="centraliza">
  <div id="primary">

    <?php if (get_field('barra_lateral')) : ?>
      <aside class="quemsomos" style="width:26%; float: right;">
        <?php the_field('barra_lateral'); ?>
      </aside>
      <div class="" style="width:66%; float: left;">

        <?php the_content(); ?>
      </div>

    <?php else : ?>
      <div class="">
        <?php the_content(); ?>
      </div>
    <?php endif; ?>

    <div class="row">

      <?php
      // Check if rows exist.
      if (have_rows('episodio')) :

        // Armazene os dados em um array.
        $episodios = array();

        // Loop through rows.
        while (have_rows('episodio')) : the_row();

          // Para fazer Array dentro do Loop
          $nome_participantes = get_sub_field('nome_participantes');
          $imagem = get_sub_field('thumb_episodio');
          $link_youtube = get_sub_field('link_youtube');
          $id_episodio = get_row_index(); // Obtém o ID do episódio

          // Adicione os dados ao array.
          $episodios[$id_episodio] = array(
            'nome_participantes' => $nome_participantes,
            'imagem' => $imagem,
            'link_youtube' => $link_youtube
          );

        endwhile;

        // Ordene o array em ordem decrescente com base nos IDs.
        krsort($episodios);

        // Loop through sorted array to display the content.
        $idx = 0;
        foreach ($episodios as $id_episodio => $episodio) :
          $idx++;
      ?>
          <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12 offset-lg-1 offset-md-1">
            <!--Inicio Card-->
            <div class="card">
              <div class="card-body">
                <div class="card-title">
                  <h5><?php echo $episodio['nome_participantes']; ?></h5>
                  <div class="d-flex justify-content-center">
                    <a href="#modal" id="linkModal<?php echo $idx; ?>" data-title="<?php echo $episodio['nome_participantes']; ?>" data-whatever="<?php echo esc_html($episodio['link_youtube']); ?>" class="card-link">
                      <img class="img-fluid" width="100%" src="<?php echo $episodio['imagem']; ?>">
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- MODAL -->
          <div class="modal fade" id="modal<?php echo $idx; ?>" tabindex="-1" role="dialog" aria-labelledby="modalLabel<?php echo $idx; ?>" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title center" id="modalLabel<?php echo $idx; ?>"><?php echo $episodio['nome_participantes']; ?></h5>
                </div>
                <div class="modal-body center"><?php echo $episodio['link_youtube']; ?></div>
              </div>
            </div>
          </div>
          <script>
            jQuery(document).ready(function($) {
              $("#linkModal<?php echo $idx; ?>").on("click", function() {
                $("#modal<?php echo $idx; ?>").dialog("open");
              });
              $("#modal<?php echo $idx; ?>").dialog({
                autoOpen: false,
                height: 430,
                width: 600,
                modal: true,
                show: {
                  effect: "blind",
                  duration: 1000
                },
              });
            });
          </script>
      <?php endforeach;
      endif;
      ?>
    </div>

    <?php if (get_field('instituicoes_fundadoras')) : ?>
      <div class="" style="width: 100%; display:table;">
        <div class="barra-titulo-m">
          <div class="col">
            <span class="header">Instituições Fundadoras</span>
          </div>
        </div>
        <?php the_field('instituicoes_fundadoras'); ?>
      </div>
    <?php else : ?>
    <?php endif; ?>
  </div><!-- #content -->
</div><!-- #primary -->

<style>
  .row {
    display: -ms-flexbox;
    display: flex;
    -ms-flex-wrap: wrap;
    flex-wrap: wrap;
    margin-right: -15px;
    margin-left: -15px;
    margin-top: 20px;

  }

  .card {
    position: relative;
    display: -ms-flexbox;
    display: flex;
    -ms-flex-direction: column;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 1px solid rgba(0, 0, 0, .125);
    border-radius: .25rem;
  }

  .card {
    word-wrap: break-word;
    margin-bottom: 30px;
  }

  .card-body {
    -ms-flex: 1 1 auto;
    flex: 1 1 auto;
    padding: 1.25rem;
  }

  .card-title {
    margin-bottom: .75rem;
  }

  .h5,
  h5 {
    font-size: 1.25rem;
  }

  .justify-content-center {
    -ms-flex-pack: center !important;
    justify-content: center !important;
  }

  .d-flex {
    display: -ms-flexbox !important;
    display: flex !important;
  }

  img {
    vertical-align: middle;
    border-style: none;
  }

  .img-fluid {
    max-width: 100%;
    height: auto;
  }

  @media (min-width: 992px) {
    .offset-lg-1 {
      margin-left: 8.333333%;
    }
  }

  @media (min-width: 992px) {
    .col-lg-5 {
      -ms-flex: 0 0 41.666667%;
      flex: 0 0 41.666667%;
      max-width: 41.666667%;
    }
  }
</style>

<?php get_footer(); ?>