<?php
/**
 * Template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
<div class="barra-titulo">
	<div class="centraliza">
	<span class="header">Publicações</span>
	</div>
</div>
<section id="primary">
	<div id="content" role="main">
		<div>
		<?php 
		
		$terms = get_terms([
			'taxonomy' => 'cat_publicacoes',
      'orderby' => 'description',
			'hide_empty' => true,
			
		]);
		foreach ($terms as $term){
			//echo $term->slug." : ";
			//echo $term->name." : ";
      
			echo "<div class='barra-titulo'><div class='centraliza'><h1>" . $term->name . "</h1></div></div>";
			echo "<div class='centraliza'>";
			query_posts('post_type=publicacoes&cat_publicacoes='. $term->slug .'&order=DESC');
			if (have_posts()) : while (have_posts()) : the_post();

      if ( has_post_thumbnail() ) {
        echo '<div class="bloc_publicacao"><div class="mask-img">'. get_the_post_thumbnail() .'</div>';
      }
      
      //if ( has_post_thumbnail() ) {
      //  echo "<div class='bloc_publicacao'><div class='mask-img'>";
      //  the_post_thumbnail();
      //  echo "</div>";
      //}

			//echo "<div class='bloc_publicacao'><div class='mask-img'>";
      //the_post_thumbnail('thumb-capa');
      //echo "</div>";
      echo '<div class="info-publicacao"><h2>'. get_the_title() .'</h2>';
      echo '<h3>'.get_field('autor').'</h3>';
  
      if( get_field( 'link_ler_texto' ) ): 
      echo '<a href="' .get_field('link_ler_texto'). ' "target="_blank" alt="Leia a Publicação ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> LEIA AQUI O TEXTO COMPLETO GRÁTIS </a><br><br>';
      endif; 

      if( get_field( 'link_compre' ) ): 
      echo '<a href="' .get_field('link_compre'). ' "target="_blank" alt="COMPRE AQUI A VERSÃO IMPRESSA DA PUBLICAÇÃO ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> COMPRE AQUI A VERSÃO IMPRESSA </a><br><br>';
      endif;

      if( get_field( 'sumario' ) ): 
      echo '<a href="' .get_field('sumario'). ' "target="_blank" alt="SUMÁRIO DA PUBLICAÇÃO ' .get_the_title(). '" class="btn-mais" ><i class="fa fa-angle-right" aria-hidden="true"></i> SUMÁRIO</a><br><br>';
      endif;
      
	
      echo "</div></div>";
  
			endwhile; 
			else : echo "-";
			endif;
			wp_reset_query();

      echo "</div>";
		  }
		
		?>
		
		</div>
	</div><!-- #content -->
</section><!-- #primary -->

	</div><!-- #content -->
</section><!-- #primary -->


<style>


</style>	

<?php //get_sidebar(); ?>
<?php get_footer(); ?>
