<?php

// GUTENBERG
add_filter('use_block_editor_for_post', '__return_false', 10); // disable for posts
add_filter('use_block_editor_for_post_type', '__return_false', 10); // disable for post types

// Adicionando MENUS
function add_menuclass($ulclass) {
  return preg_replace('/<a /', '<a class="nav-link js-scroll-trigger"', $ulclass, 10);
}
add_filter('wp_nav_menu','add_menuclass');
 
function register_my_menus()
{
    register_nav_menus(
        array(
            'menu_home' => __('menu_home')
        )
    );
	
}
add_action('init', 'register_my_menus');

// MEDIA SIZE (THUMB)
add_image_size('thumb-banner', 1280, 580, true);
add_image_size('thumb-capa', 150, 225, true);


// RETIRAR BLOG DA URL PERMALINK MULTISITE
function filter_category_link( $termlink, $term_term_id ) { 
    $termlink = home_url('/blog/'. $get_term( $term_term_id )->name .'/');
    return $termlink; 
}; 
         
add_filter( 'category_link', 'filter_category_link', 10, 2 );

// PRINCIPAL
function type_post_principal()
{
    $labels = array(
        'name' => _x('Principal', 'post type general name'),
        'singular_name' => _x('Principal', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Principal'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'principal' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('principal', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_principal');

/* CATEGORIA PRINCIPAL */
register_taxonomy(
    "catprincipal",
    "principal",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);


// BANNERS
function type_post_banners()
{
    $labels = array(
        'name' => _x('Banners', 'post type general name'),
        'singular_name' => _x('Banner', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Banners'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'banners' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('banners', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_banners');



// PUBLICACOES
function type_post_publicacoes()
{
    $labels = array(
        'name' => _x('Publicações', 'post type general name'),
        'singular_name' => _x('Publicação', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Publicações'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'publicacoes' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('publicacoes', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_publicacoes');

/* CATEGORIA PUBLICACOES */
register_taxonomy(
    "cat_publicacoes",
    "publicacoes",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);






// BIBLIOTECA
function type_post_biblioteca()
{
    $labels = array(
        'name' => _x('Biblioteca', 'post type general name'),
        'singular_name' => _x('Biblioteca', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Biblioteca'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'biblioteca' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('biblioteca', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_biblioteca');

/* CATEGORIA BIBLIOTECA */
register_taxonomy(
    "cat_biblioteca",
    "biblioteca",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);


/* 1 de 2 - Display a custom taxonomy dropdown in admin */
add_action('restrict_manage_posts', 'tsm_filter_post_type_by_taxonomy');
function tsm_filter_post_type_by_taxonomy() {
	global $typenow;
	$post_type = 'biblioteca'; // change to your post type
	$taxonomy  = 'cat_biblioteca'; // change to your taxonomy
	if ($typenow == $post_type) {
		$selected      = isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '';
		$info_taxonomy = get_taxonomy($taxonomy);
		wp_dropdown_categories(array(
			'show_option_all' => sprintf( __( 'Show all %s', 'textdomain' ), $info_taxonomy->label ),
			'taxonomy'        => $taxonomy,
			'name'            => $taxonomy,
			'orderby'         => 'name',
			'selected'        => $selected,
			'show_count'      => true,
			'hide_empty'      => true,
		));
	};
}
/* 2 de 2 - Display a custom taxonomy dropdown in admin */
add_filter('parse_query', 'tsm_convert_id_to_term_in_query');
function tsm_convert_id_to_term_in_query($query) {
	global $pagenow;
	$post_type = 'biblioteca'; // change to your post type
	$taxonomy  = 'cat_biblioteca'; // change to your taxonomy
	$q_vars    = &$query->query_vars;
	if ( $pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $post_type && isset($q_vars[$taxonomy]) && is_numeric($q_vars[$taxonomy]) && $q_vars[$taxonomy] != 0 ) {
		$term = get_term_by('id', $q_vars[$taxonomy], $taxonomy);
		$q_vars[$taxonomy] = $term->slug;
	}
}
flush_rewrite_rules();


// VIDEOTECA
function type_post_videoteca()
{
    $labels = array(
        'name' => _x('Videoteca', 'post type general name'),
        'singular_name' => _x('Videoteca', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Videoteca'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'videoteca' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('videoteca', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_videoteca');


// SUBTITULO 
add_post_type_support( 'videoteca', 'wps_subtitle' );



