<?php

// GUTENBERG
add_filter('use_block_editor_for_post', '__return_false', 10); // disable for posts
add_filter('use_block_editor_for_post_type', '__return_false', 10); // disable for post types

// Adicionando MENUS
function add_menuclass($ulclass) {
  return preg_replace('/<a /', '<a class="nav-link js-scroll-trigger"', $ulclass, 10);
}
add_filter('wp_nav_menu','add_menuclass');
 
function register_my_menus()
{
    register_nav_menus(
        array(
            'menu_home' => __('menu_home')
        )
    );
	
}
add_action('init', 'register_my_menus');

// MEDIA SIZE (THUMB)
add_image_size('thumb-banner', 1280, 580, true);
add_image_size('thumb-capa', 150, 225, true);


// RETIRAR BLOG DA URL PERMALINK MULTISITE
function filter_category_link( $termlink, $term_term_id ) { 
    $termlink = home_url('/blog/'. $get_term( $term_term_id )->name .'/');
    return $termlink; 
}; 
         
add_filter( 'category_link', 'filter_category_link', 10, 2 );

// PRINCIPAL
function type_post_principal()
{
    $labels = array(
        'name' => _x('Principal', 'post type general name'),
        'singular_name' => _x('Principal', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Principal'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'principal' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('principal', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_principal');

/* CATEGORIA PRINCIPAL */
register_taxonomy(
    "catprincipal",
    "principal",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);


// BANNERS
function type_post_banners()
{
    $labels = array(
        'name' => _x('Banners', 'post type general name'),
        'singular_name' => _x('Banner', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Banners'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'banners' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('banners', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_banners');



// PUBLICACOES
function type_post_publicacoes()
{
    $labels = array(
        'name' => _x('Publicações', 'post type general name'),
        'singular_name' => _x('Publicação', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Publicações'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'publicacoes' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('publicacoes', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_publicacoes');

/* CATEGORIA PUBLICACOES */
register_taxonomy(
    "cat_publicacoes",
    "publicacoes",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);






// BIBLIOTECA
function type_post_biblioteca()
{
    $labels = array(
        'name' => _x('Biblioteca', 'post type general name'),
        'singular_name' => _x('Biblioteca', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Biblioteca'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'biblioteca' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('biblioteca', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_biblioteca');

/* CATEGORIA BIBLIOTECA */
register_taxonomy(
    "cat_biblioteca",
    "biblioteca",
    array(
        "label" => "Categoria",
        "singular_label" => "Categoria",
        "rewrite" => true,
        "hierarchical" => true
    )
);


// VIDEOTECA
function type_post_videoteca()
{
    $labels = array(
        'name' => _x('Videoteca', 'post type general name'),
        'singular_name' => _x('Videoteca', 'post type singular name'),
        'add_new' => _x('Adicionar', 'Novo'),
        'add_new_item' => __('Novo'),
        'edit_item' => __('Editar'),
        'new_item' => __('Nova'),
        'view_item' => __('Ver'),
        'search_items' => __('Procurar'),
        'not_found' =>  __('Nenhum registro encontrado'),
        'not_found_in_trash' => __('Nenhum registro encontrado na lixeira'),
        'parent_item_colon' => '',
        'menu_name' => 'Videoteca'
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'public_queryable' => true,
        'show_ui' => true,
		'show_in_rest' => false,
        'query_var' => true,
        'rewrite'   => array( 'slug' => 'videoteca' ),
        'capability_type' => 'page',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'secondary-image' => true,
        'subtitle' => true,
        'meta_box_test' => true, 
        'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt', 'custom-fields', 'revisions', 'post-tag', 'secondary-image', 'subtitle', 'meta_box_test')
    );
    register_post_type('videoteca', $args);
    flush_rewrite_rules();
}
add_action('init', 'type_post_videoteca');


// SUBTITULO 
add_post_type_support( 'videoteca', 'wps_subtitle' );



// DROPDOWN

function filter_biblioteca_by_taxonomies( $post_type, $which ) { // Alterar nome do filtro

	// Apply this only on a specific post type
	if ( 'biblioteca' !== $post_type )
		return;

	// A list of taxonomy slugs to filter by
	$taxonomies = array( 'cat_biblioteca' );

	foreach ( $taxonomies as $taxonomy_slug ) {

		// Retrieve taxonomy data
		$taxonomy_obj = get_taxonomy( $taxonomy_slug );
		$taxonomy_name = $taxonomy_obj->labels->name;

		// Retrieve taxonomy terms
		$terms = get_terms( $taxonomy_slug );

		// Display filter HTML
		echo "<select name='{$taxonomy_slug}' id='{$taxonomy_slug}' class='postform'>";
		echo '<option value="">' . sprintf( esc_html__( 'Mostrar %s', 'text_domain' ), $taxonomy_name ) . '</option>';
		foreach ( $terms as $term ) {
			printf(
				'<option value="%1$s" %2$s>%3$s (%4$s)</option>',
				$term->slug,
				( ( isset( $_GET[$taxonomy_slug] ) && ( $_GET[$taxonomy_slug] == $term->slug ) ) ? ' selected="selected"' : '' ),
				$term->name,
				$term->count
			);
		}
		echo '</select>';
	}

}
add_action( 'restrict_manage_posts', 'filter_biblioteca_by_taxonomies' , 10, 2); // Alterar nome do filtro



function filter_publicacoes_by_taxonomies( $post_type, $which ) { // Alterar nome do filtro

	// Apply this only on a specific post type
	if ( 'publicacoes' !== $post_type )
		return;

	// A list of taxonomy slugs to filter by
	$taxonomies = array( 'cat_publicacoes' );

	foreach ( $taxonomies as $taxonomy_slug ) {

		// Retrieve taxonomy data
		$taxonomy_obj = get_taxonomy( $taxonomy_slug );
		$taxonomy_name = $taxonomy_obj->labels->name;

		// Retrieve taxonomy terms
		$terms = get_terms( $taxonomy_slug );

		// Display filter HTML
		echo "<select name='{$taxonomy_slug}' id='{$taxonomy_slug}' class='postform'>";
		echo '<option value="">' . sprintf( esc_html__( 'Mostrar %s', 'text_domain' ), $taxonomy_name ) . '</option>';
		foreach ( $terms as $term ) {
			printf(
				'<option value="%1$s" %2$s>%3$s (%4$s)</option>',
				$term->slug,
				( ( isset( $_GET[$taxonomy_slug] ) && ( $_GET[$taxonomy_slug] == $term->slug ) ) ? ' selected="selected"' : '' ),
				$term->name,
				$term->count
			);
		}
		echo '</select>';
	}

}
add_action( 'restrict_manage_posts', 'filter_publicacoes_by_taxonomies' , 10, 2); // Alterar nome do filtro